#include <d3d8.h>

#include ".\GSEdit.h"
#include ".\GSMenu.h"
#include ".\LD10.h"



CGSEdit::CGSEdit()
{

  m_CurObj = LD10::GO_STEEL_DIAMOND;
  m_CurTile = LD10::TILE_WALL;

  m_CurLevel = 1;
  m_ButtonReleased = false;
  m_StartLifeTime = 0;
  m_Mode = MODE_TILE;
  m_NameMode = false;
  m_UnitNumber = 0;

  m_Level.Load( m_CurLevel );

}



CGSEdit::~CGSEdit()
{

}



void CGSEdit::Display( IDirect3DDevice8* pDevice )
{

  m_Level.Render();

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG1 );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );

  if ( m_Mode == MODE_TILE )
  {
    theApp.RenderTextureSection( theApp.m_MouseX - 10, theApp.m_MouseY - 10, theApp.m_Tiles[m_CurTile] );
  }
  else if ( m_Mode == MODE_UNIT )
  {
    GameObject*    pObj = m_Level.CreateObject( m_CurObj );

    pObj->m_DispX = theApp.m_MouseX;
    pObj->m_DispY = theApp.m_MouseY;

    if ( m_CurObj == LD10::GO_TIMEBOMB )
    {
      pObj->m_LifeTime = ( 5.0f / 9.0f ) * m_StartLifeTime;
      pObj->m_Texture = (LD10::TextureTypes)( LD10::TEX_TIMEBOMB_8 + (int)( pObj->m_LifeTime / ( 5.0f / 9.0f ) ) );
    }
    else if ( m_CurObj == LD10::GO_STEEL_DIAMOND )
    {
      pObj->m_Number = m_UnitNumber;
    }
    pObj->Render();

    m_Level.RemoveObject( pObj );
  }

  char      szTemp[200];

  wsprintf( szTemp, "Level: %d Bombs: %d Unit: %d", m_CurLevel, m_Level.m_BombsAvailable, m_UnitNumber );
  theApp.Print( 2, 442, szTemp );

  if ( m_NameMode )
  {
    theApp.Print( 200, 442, "Name Mode" );
  }
  else if ( m_Mode == MODE_TILE )
  {
    theApp.Print( 200, 442, "Tile Mode" );
  }
  else if ( m_Mode == MODE_UNIT )
  {
    theApp.Print( 200, 442, "Unit Mode" );
  }
  std::string   Display = "Name:";
  Display += m_Level.m_Name;
  theApp.Print( 400, 442, Display.c_str() );

  theApp.Print( 2, 462, "M Toggle Mode  +/- Modify current Item  1/2 Switch Level  3/4 Change available bombs  5 Time  6 Number" );

}



void CGSEdit::UpdateFrame( const float fElapsedTime )
{

}



void CGSEdit::OnChar( int iChar )
{

  if ( m_NameMode )
  {
    if ( iChar == VK_BACK )
    {
      if ( m_Level.m_Name.length() )
      {
        m_Level.m_Name.resize( m_Level.m_Name.length() - 1 );
      }
    }
    else if ( iChar >= 32 )
    {
      m_Level.m_Name += (char)iChar;
    }
    return;
  }

  if ( iChar == 27 )
  {
    theApp.NextState( new CGSMenu() );
  }
  else if ( iChar == 'm' )
  {
    m_Mode = (Mode)( ( m_Mode + 1 ) % MODE_LAST_ENTRY );
  }
  else if ( iChar == 'n' )
  {
    m_NameMode = true;
  }
  else if ( iChar == '+' )
  {
    if ( m_Mode == MODE_TILE )
    {
      m_CurTile = (LD10::TileTypes)( ( m_CurTile + 1 ) % LD10::TILE_LAST_ENTRY );
    }
    else if ( m_Mode == MODE_UNIT )
    {
      m_CurObj = (LD10::GameObjectType)( ( m_CurObj + 1 ) % LD10::GO_LAST_ENTRY );
    }
  }
  else if ( iChar == '-' )
  {
    if ( m_Mode == MODE_TILE )
    {
      m_CurTile = (LD10::TileTypes)( ( m_CurTile + LD10::TILE_LAST_ENTRY - 1 ) % LD10::TILE_LAST_ENTRY );
    }
    else if ( m_Mode == MODE_UNIT )
    {
      m_CurObj = (LD10::GameObjectType)( ( m_CurObj + LD10::GO_LAST_ENTRY - 1 ) % LD10::GO_LAST_ENTRY );
    }
  }

}



void CGSEdit::OnMouse( int iX, int iY, int iButtons )
{

  if ( m_Mode == MODE_TILE )
  {
    if ( iY / 20 < 22 )
    {
      if ( iButtons & 1 )
      {
        m_Level.m_Field[iX / 20][iY / 20] = m_CurTile;
      }
      else if ( iButtons & 2 )
      {
        m_CurTile = m_Level.m_Field[iX / 20][iY / 20];
      }
    }
  }
  else if ( m_Mode == MODE_UNIT )
  {
    if ( ( m_ButtonReleased )
    &&   ( iButtons & 1 ) )
    {
      m_ButtonReleased = false;
      GameObject* pObj = m_Level.CreateObject( m_CurObj );

      pObj->m_DispX = theApp.m_MouseX;
      pObj->m_DispY = theApp.m_MouseY;
      if ( m_CurObj == LD10::GO_TIMEBOMB )
      {
        pObj->m_LifeTime = ( 5.0f / 9.0f ) * m_StartLifeTime;
        pObj->m_Texture = (LD10::TextureTypes)( LD10::TEX_TIMEBOMB_8 + (int)( pObj->m_LifeTime / ( 5.0f / 9.0f ) ) );
      }
      else if ( m_CurObj == LD10::GO_STEEL_DIAMOND )
      {
        pObj->m_Number = m_UnitNumber;
      }
    }
    else if ( iButtons & 2 )
    {
      Level::tListObjects::iterator   itObj( m_Level.m_Objects.begin() );
      while ( itObj != m_Level.m_Objects.end() )
      {
        GameObject& Obj( *itObj );

        if ( ( abs( Obj.m_DispX - theApp.m_MouseX ) < 20 )
        &&   ( abs( Obj.m_DispY - theApp.m_MouseY ) < 20 ) )
        {
          m_Level.m_Objects.erase( itObj );
          break;
        }

        ++itObj;
      }
    }
  }

  if ( !( iButtons & 1 ) )
  {
    m_ButtonReleased = true;
  }

}



void CGSEdit::OnKeyDown( int iChar )
{

  if ( m_NameMode )
  {
    if ( iChar == VK_RETURN )
    {
      m_NameMode = false;
    }
    return;
  }

  if ( iChar == VK_F2 )
  {
    m_Level.Save( m_CurLevel );
  }
  else if ( iChar == '1' )
  {
    if ( m_CurLevel > 1 )
    {
      --m_CurLevel;
      m_Level.Load( m_CurLevel );
    }
  }
  else if ( iChar == '2' )
  {
    ++m_CurLevel;
    m_Level.Load( m_CurLevel );
  }
  else if ( iChar == '3' )
  {
    if ( m_Level.m_BombsAvailable > 1 )
    {
      --m_Level.m_BombsAvailable;
    }
  }
  else if ( iChar == '4' )
  {
    ++m_Level.m_BombsAvailable;
  }
  else if ( iChar == '5' )
  {
    if ( m_Mode == MODE_UNIT )
    {
      m_StartLifeTime = ( ( m_StartLifeTime + 1 ) % 9 );
    }
  }
  else if ( iChar == '6' )
  {
    if ( m_Mode == MODE_UNIT )
    {
      m_UnitNumber = ( m_UnitNumber + 1 ) % 10;
    }
  }

}



